/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jclass.datasource.ColumnModel;
import jclass.datasource.DataModelEvent;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataTableAbstractionLayer;
import jclass.datasource.DataTableModel;
import jclass.datasource.LocaleBundle;
import jclass.datasource.MetaDataModel;
import jclass.datasource.StoreModel;
import jclass.datasource.VirtualColumnModel;
import jclass.datasource.treemodel.TreeIterator;
import jclass.datasource.treemodel.TreeNode;

public class BaseDataTable
extends TreeNode
implements DataTableModel,
DataTableAbstractionLayer {
    static final long serialVersionUID = 6854509779176042765L;
    protected MetaDataModel metaData;
    protected long parentRow;
    protected StoreModel store;
    protected int initialHashtableSize = 5;
    protected Hashtable updatedRows;
    protected Hashtable insertedRows;
    protected Hashtable rowIndexBeforeEvent;
    protected Hashtable[] rowCaches;
    protected int cursor = -1;
    protected Hashtable logicallyDeletedRows = new Hashtable(this.initialHashtableSize);
    private Object userData;
    private Object internalData;
    private Vector eventQueue;
    private static long bookmark = 1L;
    private String currentColumn;

    private BaseDataTable() {
        super(null);
        this.updatedRows = new Hashtable(this.initialHashtableSize);
        this.insertedRows = new Hashtable(this.initialHashtableSize);
        this.rowCaches = new Hashtable[]{this.logicallyDeletedRows, this.updatedRows, this.insertedRows};
        this.eventQueue = new Vector();
        this.rowIndexBeforeEvent = new Hashtable(this.initialHashtableSize);
    }

    public BaseDataTable(MetaDataModel metaDataModel) {
        this();
        this.metaData = metaDataModel;
        this.parentRow = -1L;
        this.createStore();
    }

    public BaseDataTable(MetaDataModel metaDataModel, long l) {
        this();
        this.metaData = metaDataModel;
        this.parentRow = l;
        this.createStore();
    }

    public int getRowCount() {
        return this.store.getRowCount();
    }

    public int getRowStatus(long l) {
        if (this.logicallyDeleted(l)) {
            return 3;
        }
        if (this.updatedRows.containsKey(new Long(l))) {
            return 1;
        }
        if (this.insertedRows.containsKey(new Long(l))) {
            return 2;
        }
        if (this.store.getIndex(l) != -1) {
            return 4;
        }
        return 5;
    }

    public long getRowIdentifier(int n) {
        return this.store.getBookmark(n);
    }

    public Object getResultData(long l, String string) throws DataModelException {
        try {
            ColumnModel columnModel = this.metaData.getColumnObject(string);
            if (columnModel instanceof VirtualColumnModel) {
                return ((VirtualColumnModel)columnModel).getResultData(this, l);
            }
            return this.getCell(l, string);
        }
        catch (DataModelException dataModelException) {
            throw dataModelException;
        }
        catch (Exception exception) {
            throw new DataModelException(l, string, this, 107, exception);
        }
    }

    public DataTableModel createTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
        DataTableModel dataTableModel = this.getTable(l, treeNode);
        if (dataTableModel != null) {
            return dataTableModel;
        }
        if (l != -1L) {
            dataTableModel = this.materializeTable(dataModelListener, l, treeNode);
        }
        this.append((TreeNode)((Object)dataTableModel));
        return dataTableModel;
    }

    public DataTableModel getTable(long l, TreeNode treeNode) {
        MetaDataModel metaDataModel = (MetaDataModel)((Object)treeNode);
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
            if (dataTableModel.getParentBookmark() != l || !dataTableModel.getMetaData().equals(metaDataModel)) continue;
            return dataTableModel;
        }
        return null;
    }

    public MetaDataModel getMetaData() {
        return this.metaData;
    }

    public long getParentBookmark() {
        return this.parentRow;
    }

    public long addRow(DataModelListener dataModelListener) throws DataModelException {
        try {
            if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, -1L, "", 1))) {
                return -1L;
            }
            Object object = this.createNewRow();
            long l = this.addInternalRow(object);
            this.insertedRows.put(new Long(l), object);
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 101));
            return l;
        }
        catch (Exception exception) {
            throw new DataModelException(101, exception);
        }
    }

    public void deleteRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 5))) {
            return;
        }
        int n = this.getRowStatus(l);
        if (n != 4) {
            this.cancelChanges(dataModelListener, l);
            if (n == 2) {
                return;
            }
        }
        this.logicallyDeletedRows.put(new Long(l), this.getRowFromCache(l));
        if (this.metaData.getCommitPolicy() == 1) {
            try {
                this.commitRow2(dataModelListener, l);
                this.commitTransactionAndProcessEvent(dataModelListener, l);
                return;
            }
            catch (DataModelException dataModelException) {
                this.removeRowFromLogicallyDeletedTable(l);
                throw dataModelException;
            }
        }
        if (this.metaData.getShowDeletedRows()) {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
            return;
        }
        Long l2 = new Long(l);
        this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
        this.removeRowFromOriginalRowTable(l);
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
        this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
        this.rowIndexBeforeEvent.remove(l2);
    }

    public void updateCell(DataModelListener dataModelListener, long l, String string, Object object) throws DataModelException {
        if (!this.hasValueChanged(object, this.getResultData(l, string))) {
            return;
        }
        if (!this.prepareCellUpdate(dataModelListener, l, string)) {
            return;
        }
        this.setRowDirty(l);
        try {
            this.setValueAt(l, string, object);
        }
        catch (Exception exception) {
            throw new DataModelException(l, string, this, 100, exception);
        }
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, string, 100));
    }

    public boolean commitRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 10))) {
            return false;
        }
        if (this.getRowStatus(l) == 4 || this.getRowStatus(l) == 5) {
            return true;
        }
        this.commitRow2(dataModelListener, l);
        this.commitTransactionAndProcessEvent(dataModelListener, l);
        return true;
    }

    public void commitAll(DataModelListener dataModelListener) throws DataModelException {
        this.commitThisLevel(dataModelListener);
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
            dataTableModel.commitAll(dataModelListener);
        }
    }

    public void conditionallyCommitYourselfAndChildren(DataModelListener dataModelListener) throws DataModelException {
        if (this.metaData.getCommitPolicy() != 3) {
            this.commitThisLevel(dataModelListener);
        }
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
            dataTableModel.conditionallyCommitYourselfAndChildren(dataModelListener);
        }
    }

    public void cancelAllRowChanges(DataModelListener dataModelListener) throws DataModelException {
        Object object;
        Object object2;
        int n = 0;
        while (n < this.rowCaches.length) {
            object2 = (Hashtable)this.rowCaches[n].clone();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                this.cancelRowChanges(dataModelListener, (Long)object.nextElement());
            }
            ++n;
        }
        object2 = this.getChildren().elements();
        while (object2.hasMoreElements()) {
            object = (DataTableModel)object2.nextElement();
            object.cancelAllRowChanges(dataModelListener);
        }
    }

    public void cancelRowChanges(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 8))) {
            return;
        }
        this.cancelChanges(dataModelListener, l);
    }

    public long getRootAncestorBookmark(long l) {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel == null) {
            return l;
        }
        if (((TreeNode)((Object)dataTableModel)).getParent() == null) {
            return this.parentRow;
        }
        return dataTableModel.getRootAncestorBookmark(l);
    }

    public void getAncestors(Vector vector) {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel != null && ((TreeNode)((Object)dataTableModel)).getParent() != null) {
            dataTableModel.getAncestors(vector);
        }
        if (this.parentRow != -1L) {
            vector.addElement(new Long(this.parentRow));
        }
    }

    public void requeryRowAndDetails(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 3))) {
            return;
        }
        this.requeryRow(dataModelListener, l);
        this.removeChildren();
        this.metaData.getDataModel().clearCurrentPath(this.metaData);
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 109));
    }

    public DataTableModel requeryLevel() throws Exception {
        return this;
    }

    public boolean first() {
        try {
            if (this.getRowCount() > 0) {
                this.cursor = 0;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean last() {
        try {
            if (this.getRowCount() > 0) {
                this.cursor = this.store.getRowCount() - 1;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean next() {
        if (++this.cursor < this.store.getRowCount()) {
            return true;
        }
        --this.cursor;
        return false;
    }

    public boolean previous() {
        if (--this.cursor > -1) {
            return true;
        }
        ++this.cursor;
        return false;
    }

    public void beforeFirst() {
        this.cursor = -1;
    }

    public void afterLast() {
        this.cursor = this.store.getRowCount();
    }

    public boolean isBeforeFirst() {
        return this.cursor == -1;
    }

    public boolean isAfterLast() {
        return this.cursor >= this.store.getRowCount();
    }

    public void relative(int n) throws DataModelException {
        int n2 = this.cursor + n;
        if (n2 < this.store.getRowCount() + 1 && n2 > -2) {
            this.cursor = n2;
            return;
        }
        Exception exception = new Exception(String.valueOf(LocaleBundle.string("Relative move failed. Index out of bounds. ")) + n2);
        throw new DataModelException(107, exception);
    }

    public void absolute(int n) throws DataModelException {
        if (n > 0 && n <= this.store.getRowCount()) {
            this.cursor = n - 1;
            return;
        }
        Exception exception = new Exception(String.valueOf(LocaleBundle.string("Absolute move failed. Ordinal out of bounds. ")) + n);
        throw new DataModelException(107, exception);
    }

    public long getCurrentBookmark() throws DataModelException {
        if (this.store.getRowCount() < 1) {
            return 0L;
        }
        if (this.cursor >= this.store.getRowCount() || this.cursor < 0) {
            Exception exception = new Exception(LocaleBundle.string("Error getting current bookmark. Are there any rows?"));
            throw new DataModelException(-1L, "", this, 107, exception);
        }
        return this.store.getBookmark(this.cursor);
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getInternalData() {
        return this.internalData;
    }

    public void setInternalData(Object object) {
        this.internalData = object;
    }

    public void processEventQueue(DataModelListener dataModelListener) throws DataModelException {
        Enumeration enumeration = this.eventQueue.elements();
        while (enumeration.hasMoreElements()) {
            long l = (Long)enumeration.nextElement();
            this.processRowEvent(dataModelListener, l);
        }
        this.eventQueue.removeAllElements();
        Enumeration enumeration2 = this.getChildren().elements();
        while (enumeration2.hasMoreElements()) {
            ((DataTableModel)enumeration2.nextElement()).processEventQueue(dataModelListener);
        }
    }

    public void clearEventQueue() {
        this.eventQueue.removeAllElements();
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            ((DataTableModel)enumeration.nextElement()).clearEventQueue();
        }
    }

    public void moveCursorToRow(long l) throws DataModelException {
        int n = this.getRowIndex(l);
        if (n == -1) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Move failed, bookmark not found: ")) + l);
            throw new DataModelException(l, "", this, 107, exception);
        }
        this.cursor = n;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getRowIndex(long l) {
        if (l < 0L) {
            return -1;
        }
        int n = this.store.getIndex(l);
        if (n == -1) {
            Integer n2 = (Integer)this.rowIndexBeforeEvent.get(new Long(l));
            n = n2 != null ? n2 : -1;
        }
        return n;
    }

    public void deleteCacheChildren(DataModelListener dataModelListener) throws DataModelException {
        if (this.recursivelyDeleteChildren(this, dataModelListener)) {
            this.removeChildren();
        }
    }

    protected boolean recursivelyDeleteChildren(BaseDataTable baseDataTable, DataModelListener dataModelListener) throws DataModelException {
        if (baseDataTable == null) {
            return true;
        }
        TreeIterator treeIterator = baseDataTable.getIterator();
        while (treeIterator.hasMoreElements()) {
            baseDataTable = (BaseDataTable)treeIterator.get();
            if (baseDataTable.hasChildren() ? !this.recursivelyDeleteChildren(baseDataTable, dataModelListener) : !this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, baseDataTable, -1L, "", 12))) {
                return false;
            }
            treeIterator.nextElement();
        }
        return true;
    }

    public void moveToRow(long l) throws Exception {
        this.setAncestorPath();
        this.getMetaData().setCurrentDataTable(this);
        this.getMetaData().setCurrentBookmark(l);
    }

    public boolean isSubTreeModified(long l) {
        int n = this.getRowStatus(l);
        if (n != 4 && n != 5) {
            return true;
        }
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
            if (dataTableModel.getParentBookmark() != l || !dataTableModel.isTableOrChildrenModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isTableOrChildrenModified() {
        boolean bl = false;
        if (this.isModified()) {
            bl = true;
        } else {
            Enumeration enumeration = this.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
                if (!dataTableModel.isTableOrChildrenModified()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void commitSubTree(DataModelListener dataModelListener, long l) throws DataModelException {
        this.commitRow(dataModelListener, l);
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
            dataTableModel.commitAll(dataModelListener);
        }
    }

    public boolean isModified() {
        return this.insertedRows.size() + this.updatedRows.size() + this.logicallyDeletedRows.size() > 0;
    }

    public long[] getUpdatedRowBookmarks() {
        return this.getBookmarksFromTable(this.updatedRows);
    }

    public long[] getInsertedRowBookmarks() {
        return this.getBookmarksFromTable(this.insertedRows);
    }

    public long[] getDeletedRowBookmarks() {
        return this.getBookmarksFromTable(this.logicallyDeletedRows);
    }

    public Object cloneRow(long l) throws DataModelException {
        Object[] objectArray = (Object[])this.getRowFromCache(l);
        return objectArray.clone();
    }

    public void setValueAt(long l, String string, Object object) throws Exception {
        ((Object[])this.getRowFromCache((long)l))[this.metaData.getColumnIndex((String)string)] = object;
    }

    public void restoreRow(long l) {
        Object[] objectArray = (Object[])this.getOriginalRow(l);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            try {
                String string = this.metaData.getColumnIdentifier(n);
                if (this.columnModified(l, string)) {
                    this.setValueAt(l, string, objectArray[n]);
                }
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public Object createNewRow() throws Exception {
        int n = 0;
        try {
            n = this.metaData.getColumnCount();
        }
        catch (Exception exception) {}
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = null;
            ++n2;
        }
        return objectArray;
    }

    public void refreshRow(long l) throws Exception {
    }

    public void saveRow(long l) throws Exception {
    }

    public Object getCell(long l, String string) throws Exception {
        int n = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getRowFromCache(l);
        if (objectArray != null) {
            return objectArray[n];
        }
        return null;
    }

    public DataTableModel materializeTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
        return new BaseDataTable((MetaDataModel)((Object)treeNode), l);
    }

    public boolean fireDataModelEvent(DataModelEvent dataModelEvent) {
        return this.metaData.getDataModel().fireDataModelEvent(dataModelEvent);
    }

    public boolean fireOriginatorDataModelEvent(DataModelEvent dataModelEvent) {
        dataModelEvent.getOriginator().dataModelChanged(dataModelEvent);
        return true;
    }

    protected long getNextBookmark() {
        return bookmark++;
    }

    public long addInternalRow(Object object) {
        Long l = new Long(this.getNextBookmark());
        this.store.addRow(l, object);
        return l;
    }

    public long addInternalRow(Object object, int n) {
        long l = this.getNextBookmark();
        this.store.addRow(l, object, n);
        return l;
    }

    public Object getRowFromCache(long l) throws DataModelException {
        Object object = this.store.getRow(l);
        if (object == null) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Internal error: bookmark not found in cache: ")) + l);
            throw new DataModelException(l, "", this, 107, exception);
        }
        return object;
    }

    private boolean logicallyDeleted(long l) {
        return this.logicallyDeletedRows.size() > 0 && this.logicallyDeletedRows.containsKey(new Long(l));
    }

    protected void removeRowFromLogicallyDeletedTable(long l) {
        if (this.logicallyDeleted(l)) {
            this.logicallyDeletedRows.remove(new Long(l));
        }
    }

    public void removeRowFromUpdatedTable(long l) {
        Long l2 = new Long(l);
        if (this.updatedRows.containsKey(l2)) {
            this.updatedRows.remove(l2);
        }
    }

    public void removeRowFromInsertedTable(long l) {
        Long l2 = new Long(l);
        if (this.insertedRows.containsKey(l2)) {
            this.insertedRows.remove(l2);
        }
    }

    protected void removeRowFromOriginalRowTable(long l) {
        this.store.removeRow(l);
    }

    private void commitThisLevel(DataModelListener dataModelListener) throws DataModelException {
        int n = 0;
        while (n < this.rowCaches.length) {
            Hashtable hashtable = (Hashtable)this.rowCaches[n].clone();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                long l = (Long)enumeration.nextElement();
                if (this.metaData.getAutoCommit()) {
                    this.commitRow(dataModelListener, l);
                    continue;
                }
                this.commitRow2(dataModelListener, l);
            }
            ++n;
        }
    }

    public void cancelChanges(DataModelListener dataModelListener, long l) throws DataModelException {
        switch (this.getRowStatus(l)) {
            case 1: {
                this.restoreRow(l);
                this.removeRowFromUpdatedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                return;
            }
            case 3: {
                if (!this.metaData.getShowDeletedRows()) {
                    Object v = this.logicallyDeletedRows.get(new Long(l));
                    long l2 = this.addInternalRow(v);
                    this.removeRowFromLogicallyDeletedTable(l);
                    this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 101));
                    return;
                }
                this.removeRowFromLogicallyDeletedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                return;
            }
            case 2: {
                Long l3 = new Long(l);
                this.rowIndexBeforeEvent.put(l3, new Integer(this.store.getIndex(l)));
                this.removeInsertedRow(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
                this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
                this.rowIndexBeforeEvent.remove(l3);
                return;
            }
        }
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
    }

    private void commitTransactionAndProcessEvent(DataModelListener dataModelListener, long l) throws DataModelException {
        try {
            this.metaData.commitTransaction();
        }
        catch (Exception exception) {
            int n = this.getRowStatus(l) == 102 ? 102 : 100;
            throw new DataModelException(l, "", this, n, exception);
        }
        this.processRowEvent(dataModelListener, l);
    }

    private void commitRow2(DataModelListener dataModelListener, long l) throws DataModelException {
        if (this.getRowStatus(l) == 4) {
            return;
        }
        try {
            this.saveRow(l);
        }
        catch (Exception exception) {
            int n = this.getRowStatus(l) == 3 ? 102 : 100;
            throw new DataModelException(l, "", this, n, exception);
        }
        if (!this.metaData.getAutoCommit()) {
            this.eventQueue.addElement(new Long(l));
            return;
        }
        this.processRowEvent(dataModelListener, l);
    }

    private void processRowEvent(DataModelListener dataModelListener, long l) throws DataModelException {
        switch (this.getRowStatus(l)) {
            case 1: {
                this.removeRowFromUpdatedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                return;
            }
            case 2: {
                this.removeRowFromInsertedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                return;
            }
            case 3: {
                Long l2 = new Long(l);
                this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
                this.removeRowFromLogicallyDeletedTable(l);
                this.removeRowFromOriginalRowTable(l);
                if (this.metaData.getShowDeletedRows()) {
                    this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
                    this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
                }
                this.rowIndexBeforeEvent.remove(l2);
                return;
            }
        }
    }

    public void requeryRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 3))) {
            return;
        }
        int n = this.getRowStatus(l);
        Long l2 = new Long(l);
        this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
        this.getRow(dataModelListener, l);
        if (n == 2) {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
            this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
        } else {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
        }
        this.rowIndexBeforeEvent.remove(l2);
    }

    private void getRow(DataModelListener dataModelListener, long l) throws DataModelException {
        try {
            if (this.insertedRows.containsKey(new Long(l))) {
                this.removeInsertedRow(l);
                return;
            }
            if (this.getRowStatus(l) == 1) {
                this.cancelChanges(dataModelListener, l);
            }
            this.refreshRow(l);
            this.removeRowFromUpdatedTable(l);
            this.removeRowFromLogicallyDeletedTable(l);
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(l, "", this, 100, exception);
        }
    }

    private void removeInsertedRow(long l) {
        this.removeRowFromInsertedTable(l);
        this.removeRowFromOriginalRowTable(l);
    }

    public boolean originalCellWasNull(int n, Vector vector, Object[] objectArray) {
        int n2 = (Integer)vector.elementAt(n);
        Object object = objectArray[n2];
        return object == null;
    }

    public boolean columnModified(long l, String string) throws DataModelException {
        int n = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getOriginalRow(l);
        if (objectArray == null) {
            return false;
        }
        Object object = this.getResultData(l, string);
        Object object2 = objectArray[n];
        return this.hasValueChanged(object, object2);
    }

    private boolean hasValueChanged(Object object, Object object2) {
        return object == null && object2 != null || object2 == null && object != null || object2 != null && object != null && !object.equals(object2);
    }

    public Object getOriginalRow(long l) {
        return (Object[])this.updatedRows.get(new Long(l));
    }

    public Object getDeletedRow(long l) {
        return this.logicallyDeletedRows.get(new Long(l));
    }

    public boolean tableIsAncestor(DataTableModel dataTableModel) {
        TreeNode treeNode = (TreeNode)((Object)dataTableModel);
        while (treeNode != null) {
            if (treeNode == this) {
                return true;
            }
            treeNode = (TreeNode)treeNode.getParent();
        }
        return false;
    }

    private void setAncestorPath() {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel == null) {
            return;
        }
        ((BaseDataTable)dataTableModel).setAncestorPath();
        MetaDataModel metaDataModel = dataTableModel.getMetaData();
        metaDataModel.setCurrentDataTable(dataTableModel);
        metaDataModel.setCurrentBookmark(this.getParentBookmark());
    }

    public boolean prepareCellUpdate(DataModelListener dataModelListener, long l, String string) throws DataModelException {
        if (this.logicallyDeleted(l)) {
            Exception exception = new Exception(LocaleBundle.string("Deleted rows cannot be modified."));
            throw new DataModelException(l, string, this, 4, exception);
        }
        ColumnModel columnModel = this.metaData.getColumnObject(string);
        if (columnModel == null || columnModel instanceof VirtualColumnModel) {
            Exception exception = new Exception(LocaleBundle.string("This is a derived column.  It cannot be modified."));
            throw new DataModelException(l, string, this, 4, exception);
        }
        if (!this.metaData.isUpdateAllowedOnColumn(string) || columnModel.isReadOnly()) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Cell cannot be updated: permissions disallow it or its table name cannot be determined.")) + ": " + string);
            throw new DataModelException(l, string, this, 4, exception);
        }
        return this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, string, 4));
    }

    private long[] getBookmarksFromTable(Hashtable hashtable) {
        long[] lArray = new long[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            lArray[n++] = (Long)enumeration.nextElement();
        }
        return lArray;
    }

    private void createStore() {
        try {
            this.store = (StoreModel)this.metaData.getStoreClass().newInstance();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    public void setRowDirty(long l) {
        if (!this.insertedRows.containsKey(new Long(l)) && !this.updatedRows.containsKey(new Long(l))) {
            try {
                this.updatedRows.put(new Long(l), this.cloneRow(l));
                return;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                return;
            }
        }
    }
}

